%define name open-iscsi-kernel
%define version 2.0
%define release 8425165dfed27945e8509c141cea245d1739e372

Summary		: open-iscsi kernel modules.
Name		: %{name}
Version		: %{version}
Release		: %{release}
Vendor		: Voltaire Inc.
Source		: open-iscsi-kernel-%{version}.tar.gz
Packager	: Erez Zilber <erezz@voltaire.com>
Provides	: open-iscsi-kernel
Group		: Storage 
License		: GPL
BuildRoot:      %{_tmppath}/%{name}


%description
This package provides open-iscsi kernel modules

%define kversion $(uname -r)
%define kernel_src /lib/modules/`uname -r`/source

%prep
echo "Checking if the kernel source is installed"

%if "%{_vendor}" == "suse"
	if ! ( $(rpm -q kernel-source > /dev/null 2>&1) ) ; then
		echo "Cannot build. Please install the kernel-source rpm first"
		exit 1
	fi
%else
%if "%{_vendor}" == "redhat"
	if ! ( $(rpm -q kernel-devel > /dev/null 2>&1) ) ; then
		echo "Cannot build. Please install the kernel-devel rpm first"
		exit 1
	fi
%endif
%endif

rm -rf $RPM_BUILD_ROOT

%setup
case $(uname -r | sed "s/-ppc64\|-smp//") in
        2.6.16.21-0.8)
		echo "Backup open-iscsi h files in the kernel tree and put newer files instead"
		mv %{kernel_src}/include/scsi/iscsi_if.h %{kernel_src}/include/scsi/iscsi_if.h.saved
		cp $PWD/include/scsi/iscsi_if.h %{kernel_src}/include/scsi/
		mv %{kernel_src}/include/scsi/iscsi_proto.h %{kernel_src}/include/scsi/iscsi_proto.h.saved
		cp $PWD/include/scsi/iscsi_proto.h %{kernel_src}/include/scsi/
		mv %{kernel_src}/include/scsi/scsi_transport_iscsi.h %{kernel_src}/include/scsi/scsi_transport_iscsi.h.saved
		cp $PWD/include/scsi/scsi_transport_iscsi.h %{kernel_src}/include/scsi/
                cp $PWD/include/scsi/libiscsi.h %{kernel_src}/include/scsi/

                ;; 
        *)
                echo "%{kversion} kernel is not supported"
                exit 1
                ;;
esac

%build

echo "Building open-iscsi kernel modules"
if make -C /lib/modules/`uname -r`/build SUBDIRS="$PWD/drivers/scsi" KERNELRELEASE=`uname -r` \
		V=1  \
		SCSI_ISCSI_ATTRS=m \
		ISCSI_TCP=m; then
        echo "open-iscsi driver built OK"
	bail_out=0
else
        echo "Failed to build open-iscsi driver, cleaning up..."
	bail_out=1
fi

echo "Restoring the old open-iscsi h files"
mv %{kernel_src}/include/scsi/iscsi_if.h.saved %{kernel_src}/include/scsi/iscsi_if.h
mv %{kernel_src}/include/scsi/iscsi_proto.h.saved %{kernel_src}/include/scsi/iscsi_proto.h
mv %{kernel_src}/include/scsi/scsi_transport_iscsi.h.saved %{kernel_src}/include/scsi/scsi_transport_iscsi.h
rm %{kernel_src}/include/scsi/libiscsi.h

if [ $bail_out = 1 ] ; then
        echo "Unable to build the open-iscsi driver"
        exit 1
fi

%install
# delete the dir where the modules were built
if [ "${RPM_BUILD_ROOT}" != "/" -a -d ${RPM_BUILD_ROOT} ] ; then rm -rf ${RPM_BUILD_ROOT} ; fi

%define MODULE_LIST iscsi_tcp.ko scsi_transport_iscsi.ko libiscsi.ko

# install the open-iscsi modules into our tmp dir
2>&1 make -C /lib/modules/%{kversion}/build/ SUBDIRS=$PWD/drivers/scsi modules_install INSTALL_MOD_PATH=${RPM_BUILD_ROOT}/tmp |grep INSTALL

# put the new open-iscsi modules in a tmp location
for i in %{MODULE_LIST} ; do
        found_file=$(find ${RPM_BUILD_ROOT}/tmp | grep $i)
        if ! [ -z "$found_file" ] ; then
		found_file_dir=$(dirname $found_file)
		found_file_dir=$(echo $found_file_dir|sed "s|${RPM_BUILD_ROOT}/tmp||")
		mkdir -p ${RPM_BUILD_ROOT}$found_file_dir
		install -m755 $found_file ${RPM_BUILD_ROOT}$found_file_dir
        fi
done

rm -rf ${RPM_BUILD_ROOT}/tmp

# build the file list
FILE_LIST=%{_tmppath}/open-iscsi-kernel-file-list

find ${RPM_BUILD_ROOT} -type f| sed "s|${RPM_BUILD_ROOT}||" > ${FILE_LIST}
cat ${FILE_LIST}

%clean
[ "${RPM_BUILD_ROOT}" != "/" -a -d ${RPM_BUILD_ROOT} ] && rm -rf ${RPM_BUILD_ROOT}

%pre

#set backup dir
if [ ! -z $STACK_PREFIX ] ; then
	backup_dir=$STACK_PREFIX/backup
else
	backup_dir=/usr/local/ofed/backup
fi
KERNEL=$(uname -r)
echo "Backup /lib/modules/$KERNEL"

#backup kernel modules
for i in %{MODULE_LIST} ; do 
        found_file=$(find /lib/modules/$KERNEL | grep $i)
        if ! [ -z "$found_file" ] ; then
		found_file_dir=$(dirname $found_file)
		mkdir -p $backup_dir/$found_file_dir
		mv $found_file $backup_dir/$found_file_dir
        fi
done

%post
depmod -a

exit 0

%postun
STACK_PREFIX=$(test -x /etc/infiniband/info && /etc/infiniband/info |grep prefix|cut -f2 -d=)
if [ ! -z $STACK_PREFIX ] ; then
	backup_dir=$STACK_PREFIX/backup
else
	backup_dir=/usr/local/ofed/backup
fi
echo "Restoring /lib/modules/$(uname -r)"
for i in %{MODULE_LIST} ; do 
	cd $backup_dir
	found_file=$(find -name $i)
        if ! [ -z "$found_file" ] ; then
		found_file_dir=$(dirname $found_file|cut -f2- -d/)
		cp $found_file /$found_file_dir
        fi
done

%files -f %{_tmppath}/open-iscsi-kernel-file-list

